
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "www,forex-station.com"
#property link      "www,forex-station.com"

#property indicator_separate_window
#property indicator_buffers 3
#property strict

//
//
//
//
//

extern ENUM_TIMEFRAMES   TimeFrame        = PERIOD_CURRENT;    // Time frame
input int                FasterMA         = 10;                // Fast ma period
input int                FasterShift      = 0;                 // Fast ma shift
input ENUM_MA_METHOD     FasterMode       = MODE_EMA;          // Fast ma mode
input ENUM_APPLIED_PRICE FasterPrice      = PRICE_CLOSE;       // Fast ma price
input int                MediumMA         = 20;                // Medium ma period
input int                MediumShift      = 0;                 // Medium ma shift
input ENUM_MA_METHOD     MediumMode       = MODE_EMA;;         // Medium ma mode
input ENUM_APPLIED_PRICE MediumPrice      = PRICE_CLOSE;       // Medium ma price
input int                SlowerMA         = 40;                // Slow ma period
input int                SlowerShift      = 0;                 // Slow ma shift
input ENUM_MA_METHOD     SlowerMode       = MODE_EMA;;         // Slow ma mode
input ENUM_APPLIED_PRICE SlowerPrice      = PRICE_CLOSE;       // Slow ma price
input int                SlowestMA        = 100;               // Slowest ma period
input int                SlowestShift     = 0;                 // Slowest ma shift
input ENUM_MA_METHOD     SlowestMode      = MODE_EMA;;         // Slowest ma mode
input ENUM_APPLIED_PRICE SlowestPrice     = PRICE_CLOSE;       // Slowest ma price
input int                HistoWidth       = 3;                 // Histogram bars width
input color              UpHistoColor     = clrLimeGreen;      // Bullish color
input color              DnHistoColor     = clrRed;            // Bearish color
input color              NuHistoColor     = clrGray;           // Neutral color
input bool               alertsOn         = true;              // Alerts on true/false?
input bool               alertsOnCurrent  = false;             // Alerts open bar true/false?
input bool               alertsMessage    = true;              // Alerts message true/false?
input bool               alertsSound      = true;              // Alerts sound true/false?
input bool               alertsNotify     = false;             // Alerts notification true/false?
input bool               alertsEmail      = false;             // Alerts email true/false?
input string             soundfile        = "alert2.wav";      // Sound file to use
input bool               arrowsVisible    = true;              // Arrows visible true/false?
input bool               arrowsOnNewest   = false;             // Arrows drawn on newest bar of higher time frame bar true/false?
input string             arrowsIdentifier = "ma Arrows1";      // Unique ID for arrows
input double             arrowsUpperGap   = 1.0;               // Upper arrow gap
input double             arrowsLowerGap   = 1.0;               // Lower arrow gap
input color              arrowsUpColor    = clrBlue;           // Up arrow color
input color              arrowsDnColor    = clrCrimson;        // Down arrow color
input int                arrowsUpCode     = 233;               // Up arrow code
input int                arrowsDnCode     = 234;               // Down arrow code
input int                arrowsUpSize     = 2;                 // Up arrow size
input int                arrowsDnSize     = 2;                 // Down arrow size

double UpH[],DnH[],NuH[],ma1[],ma2[],ma3[],ma4[],valc[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_ind) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,FasterMA,0,FasterMode,FasterPrice,MediumMA,0,MediumMode,MediumPrice,SlowerMA,0,SlowerMode,SlowerPrice,SlowestMA,0,SlowestMode,SlowestPrice,HistoWidth,UpHistoColor,DnHistoColor,NuHistoColor,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundfile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsUpSize,arrowsDnSize,_buff,_ind)

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int OnInit()
{
   IndicatorBuffers(9);   
   SetIndexBuffer(0,UpH,INDICATOR_DATA); SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,HistoWidth,UpHistoColor);
   SetIndexBuffer(1,DnH,INDICATOR_DATA); SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,HistoWidth,DnHistoColor);
   SetIndexBuffer(2,NuH,INDICATOR_DATA); SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,HistoWidth,NuHistoColor);
   SetIndexBuffer(3,ma1);
   SetIndexBuffer(4,ma2);
   SetIndexBuffer(5,ma3); 
   SetIndexBuffer(6,ma4); 
   SetIndexBuffer(7,valc);
   SetIndexBuffer(8,count);
   
   IndicatorSetDouble(INDICATOR_MINIMUM,0);
   IndicatorSetDouble(INDICATOR_MAXIMUM,1);
   
   indicatorFileName = WindowExpertName();
   TimeFrame         = MathMax(TimeFrame,_Period);
   SetIndexShift(3,FasterShift *TimeFrame/_Period);
   SetIndexShift(4,MediumShift *TimeFrame/_Period);
   SetIndexShift(5,SlowerShift *TimeFrame/_Period);
   SetIndexShift(6,SlowestShift*TimeFrame/_Period);
     
   IndicatorSetString(INDICATOR_SHORTNAME,timeFrameToString(TimeFrame)+"   3ma cross");
return(INIT_SUCCEEDED);
}  
void OnDeinit(const int reason)  {  ObjectsDeleteAll(0,arrowsIdentifier+":"); }

//------------------------------------------------------------------
//
//------------------------------------------------------------------

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime& time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   int i,limit=fmin(rates_total-prev_calculated+1,rates_total-1); count[0] = limit;
   if(FasterShift <  0) limit = fmax(limit,-FasterShift);
   if(MediumShift <  0) limit = fmax(limit,-MediumShift);
   if(SlowerShift <  0) limit = fmax(limit,-SlowerShift);
   if(SlowestShift < 0) limit = fmax(limit,-SlowestShift);
      if (TimeFrame!=_Period)
      {
         limit = (int)fmax(limit,fmin(rates_total-1,_mtfCall(8,0)*TimeFrame/_Period));
         for (i=limit;i>=0 && !_StopFlag; i--)
         {
                  int y = iBarShift(NULL,TimeFrame,time[i]);
                     UpH[i] = _mtfCall(0,y);
                     DnH[i] = _mtfCall(1,y);
                     NuH[i] = _mtfCall(2,y);
         }  
   return(rates_total);
   }            
   
   //
   //
   //
           
   for (i=limit;i>=0 && !_StopFlag; i--)
   {
       ma1[i]  = iMA(_Symbol,_Period,FasterMA ,FasterShift ,FasterMode ,FasterPrice,i);
       ma2[i]  = iMA(_Symbol,_Period,MediumMA ,MediumShift ,MediumMode ,MediumPrice,i);
       ma3[i]  = iMA(_Symbol,_Period,SlowerMA ,SlowerShift ,SlowerMode ,SlowerPrice,i);
       ma4[i]  = iMA(_Symbol,_Period,SlowestMA,SlowestShift,SlowestMode,SlowestPrice,i);
       valc[i] = (ma3[i]>ma4[i] && ma2[i]>ma3[i] && ma1[i]>ma2[i]) ? 1 : (ma3[i]<ma4[i] && ma2[i]<ma3[i] && ma1[i]<ma2[i]) ? -1 : 0;
       UpH[i]  = (valc[i] == 1) ? 1 : EMPTY_VALUE;
       DnH[i]  = (valc[i] ==-1) ? 1 : EMPTY_VALUE;   
       NuH[i]  = (UpH[i]  == EMPTY_VALUE && DnH[i] == EMPTY_VALUE) ? 1 : EMPTY_VALUE;  
      
       //
       //
       //
      
       if (arrowsVisible) 
       {
         string lookFor = arrowsIdentifier+":"+(string)time[i]; if (ObjectFind(0,lookFor)==0) ObjectDelete(0,lookFor);                       
         if (i<(rates_total-1) && valc[i] != valc[i+1])
         {
            if (valc[i] == 1) drawArrow(i,arrowsUpColor,arrowsUpCode,arrowsUpSize,false);
            if (valc[i] ==-1) drawArrow(i,arrowsDnColor,arrowsDnCode,arrowsDnSize, true);
         }
      }                  
   }
   manageAlerts();
return(rates_total);
}
      
//-------------------------------------------------------------------
//
//-------------------------------------------------------------------

void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0; 
      if (valc[whichBar]!= valc[whichBar+1])
      {
         static datetime time1 = 0;
         static string   mess1 = "";
            if (valc[whichBar] == 1) doAlert(time1,mess1," crossing up");
            if (valc[whichBar] ==-1) doAlert(time1,mess1," crossing down");
      }
   }
}

//
//
//

void doAlert(datetime& previousTime, string& previousAlert, string doWhat)
{
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[0]) {
       previousAlert  = doWhat;
       previousTime   = Time[0];

       //
       //
       //

       message = timeFrameToString(_Period)+" "+_Symbol+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" 3 ma cross "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" 3 ma cross ",message);
          if (alertsSound)   PlaySound(soundfile);
   }
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------

void drawArrow(int i,color theColor,int theCode, int theSize, bool up)
{
   string name = arrowsIdentifier+":"+(string)Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //

      datetime atime = Time[i]; if (arrowsOnNewest) atime += PeriodSeconds(_Period)-1;      
      ObjectCreate(name,OBJ_ARROW,0,atime,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_WIDTH,theSize);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
